/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger.impl;

import io.gitlab.jfronny.commons.logger.impl.LoggingOutputStream;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggingPrintStream
extends PrintStream {
    private final System.Logger logger;
    private final String defaultName;
    private final  @NotNull System.Logger.Level level;

    public LoggingPrintStream(@NotNull String defaultName, @NotNull System.Logger logger, @NotNull System.Logger.Level level) {
        super(new LoggingOutputStream("[" + defaultName + "] ", logger, level), true);
        this.defaultName = Objects.requireNonNull(defaultName);
        this.logger = Objects.requireNonNull(logger);
        this.level = Objects.requireNonNull(level);
    }

    private void maybeLog(Object param) {
        String s;
        if (param instanceof String && (s = (String)param).isBlank()) {
            return;
        }
        this.logger.log(this.level, "[{0}] {1}", this.getCallerClassName().orElse(this.defaultName), param);
    }

    @Override
    public void println(boolean x) {
        this.maybeLog(x);
    }

    @Override
    public void println(char x) {
        this.maybeLog(Character.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.maybeLog(x);
    }

    @Override
    public void println(long x) {
        this.maybeLog(x);
    }

    @Override
    public void println(float x) {
        this.maybeLog(Float.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.maybeLog(x);
    }

    @Override
    public void println(char @NotNull [] x) {
        this.maybeLog(x);
    }

    @Override
    public void println(@Nullable String x) {
        this.maybeLog(x);
    }

    @Override
    public void println(@Nullable Object x) {
        this.maybeLog(x);
    }

    @Override
    public PrintStream format(@NotNull String format, Object ... args) {
        this.maybeLog(new Formatter().format(format, args).toString().stripTrailing());
        return this;
    }

    @Override
    public PrintStream format(Locale l, @NotNull String format, Object ... args) {
        this.maybeLog(new Formatter().format(l, format, args).toString().stripTrailing());
        return this;
    }

    private Optional<String> getCallerClassName() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.dropWhile(f -> PrintStream.class.isAssignableFrom(f.getDeclaringClass())).findFirst()).map(StackWalker.StackFrame::getClassName);
    }
}

